<?php

require_once('../PhpSpreadsheet/vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
$spreadsheet = new Spreadsheet();
// Set document properties
$spreadsheet->getProperties()->setCreator('Maarten Balliauw')
    ->setLastModifiedBy('Maarten Balliauw')
    ->setTitle('Office 2007 XLSX Test Document')
    ->setSubject('Office 2007 XLSX Test Document')
    ->setDescription('Test document for Office 2007 XLSX, generated using PHP classes.')
    ->setKeywords('office 2007 openxml php')
    ->setCategory('Test result file');


require_once '../config.php';
$dbhost = $cfg->host;
$dbuser = $cfg->user;
$dbpassword = $cfg->password;
$dbname = $cfg->name;


try {  
    $dbh = new PDO("mysql:host=$dbhost;dbname=$dbname;charset=utf8", $dbuser, $dbpassword);  
}  
catch(PDOException $e) {  
    echo $e->getMessage();  
}

session_start();
require_once  '../api_core.php';

    $course_id = 0;

    if(isset($argv[1]))
	$course_id = $argv[1];
    $course_check  = $argv[2];
    $type_search  = $argv[3];
    $completed  = $argv[4];
    $date1 = $argv[5];
    $date2 = $argv[6];
    $date1a = $date1;
    if($date1a == '')
         $date1a = date("m.d.Y"); 
    if($course_check == 'false')
          $course_check = '';

/*
    $course_id = 0;
    if($_GET['courseId'] != '')
        $course_id =  intval($_GET['courseId']);
    $date1 = '';
    $date2 = '';
    $type_search = '';
    $completed = 'true';
    if($_GET['date1']!='')
	$date1 = $_GET['date1'];
    if($_GET['date2']!='')
	$date2 = $_GET['date2'];
    if($_GET['completed']!='')
	$completed = $_GET['completed'];
    if($_GET['type_search']!='')
	$type_search = $_GET['type_search'];
*/


    $result = core_course_report2c($course_id , $date1, $date2, $type_search,  $completed, $course_check );
//print_r($result);
//return;

  $spreadsheet->setActiveSheetIndex(0)
    ->setCellValue('A2', '')
    ->setCellValue('B2', "Курс")
    ->setCellValue('C2', 'Количество');


  $spreadsheet->setActiveSheetIndex(0)
    ->setCellValue('A1', '')
    ->setCellValue('B1', 'дата: ')
    ->setCellValue('C1', $date1a)
    ->setCellValue('D1', $date2);


  $spreadsheet->setActiveSheetIndex(0)
    ->getColumnDimension('A')->setWidth(5);
  $spreadsheet->setActiveSheetIndex(0)
    ->getColumnDimension('B')->setWidth(80);
  $spreadsheet->setActiveSheetIndex(0)
    ->getColumnDimension('C')->setWidth(20);
  $spreadsheet->setActiveSheetIndex(0)
    ->getColumnDimension('D')->setWidth(20);


  $i = 1;
  foreach ($result['result']  as $item_course ) {
        $ii = $i+2;
	$spreadsheet->setActiveSheetIndex(0)
	->setCellValue('A'.$ii, "$i")
	->setCellValue('B'.$ii, $item_course['course'])
	->setCellValue('C'.$ii, $item_course['total']);
        $i = $i+1;
  }


// Rename worksheet
$spreadsheet->getActiveSheet()->setTitle('Отчет');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$spreadsheet->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Xlsx)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="отчет.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

//header('Content-disposition: filename="report.xlsx"');
$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
$writer->save('php://output');
//$writer->save('../output.xlsx');
exit;



?>

